/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.Row;
import org.das2.DasNameException;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;

public class RowController
extends DomNodeController {
    protected static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.row");
    Row row;
    DasRow dasRow;
    Canvas canvas;
    ApplicationController applicationController;
    PropertyChangeListener nameListener;
    PropertyChangeListener dasRowPosListener;
    PropertyChangeListener rowPosListener;

    RowController(ApplicationController applicationController, Row row) {
        super(row);
        this.row = row;
        this.applicationController = applicationController;
        row.controller = this;
        this.createNameListener();
        row.addPropertyChangeListener("parent", this.nameListener);
    }

    void createNameListener() {
        this.nameListener = evt -> {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
            if (evt.getPropertyName().equals("parent")) {
                String newid = (String)evt.getNewValue();
                this.doSetParentRow((String)evt.getOldValue(), newid);
            }
        };
    }

    private void doSetParentRow(String old, String newid) {
        if (newid.isEmpty()) {
            return;
        }
        DomNode n = this.applicationController.getElementById(newid);
        if (n == null) {
            throw new IllegalArgumentException("unable to find parent with id: " + newid);
        }
        if (!(n instanceof Row)) {
            if (old == null) {
                throw new IllegalArgumentException("unable to find Row for id: " + newid);
            }
            this.row.setParent(old);
        }
        Row newrow = (Row)n;
        this.row.controller.dasRow.setParentRow(newrow.getController().getDasRow());
    }

    PropertyChangeListener createDasRowPosListener(final List<String> minList, final List<String> maxList) {
        this.dasRowPosListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                if (maxList.contains(evt.getPropertyName())) {
                    RowController.this.row.setBottom(DasDevicePosition.formatLayoutStr((DasDevicePosition)RowController.this.dasRow, (boolean)false));
                } else if (minList.contains(evt.getPropertyName())) {
                    RowController.this.row.setTop(DasDevicePosition.formatLayoutStr((DasDevicePosition)RowController.this.dasRow, (boolean)true));
                }
            }
        };
        return this.dasRowPosListener;
    }

    PropertyChangeListener createRowPosListener() {
        this.rowPosListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)((String)evt.getNewValue()));
                    if (evt.getPropertyName().equals("top")) {
                        if (dd[0] == RowController.this.dasRow.getMinimum() && dd[1] == RowController.this.dasRow.getEmMinimum() && (int)dd[2] == RowController.this.dasRow.getPtMinimum()) {
                            logger.fine("suppressing change which would have no effect");
                        } else {
                            RowController.this.dasRow.setMin(dd[0], dd[1], (int)dd[2]);
                        }
                    } else if (evt.getPropertyName().equals("bottom")) {
                        if (dd[0] == RowController.this.dasRow.getMaximum() && dd[1] == RowController.this.dasRow.getEmMaximum() && (int)dd[2] == RowController.this.dasRow.getPtMinimum()) {
                            logger.fine("suppressing change which would have no effect");
                        } else {
                            RowController.this.dasRow.setMax(dd[0], dd[1], (int)dd[2]);
                        }
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, "parse exception: {0}", ex);
                    RowController.this.row.setTop(DasDevicePosition.formatLayoutStr((DasDevicePosition)RowController.this.dasRow, (boolean)true));
                    RowController.this.row.setBottom(DasDevicePosition.formatLayoutStr((DasDevicePosition)RowController.this.dasRow, (boolean)false));
                }
            }
        };
        return this.rowPosListener;
    }

    protected void createDasPeer(Canvas canvas, DasRow parent) {
        DasCanvas c = canvas.controller.getDasCanvas();
        this.dasRow = DasRow.create((DasCanvas)c, (DasRow)parent, (String)this.row.getTop(), (String)this.row.getBottom());
        try {
            if (this.row.getId().length() > 0) {
                this.dasRow.setDasName(this.row.getId());
            }
        }
        catch (DasNameException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.applicationController.bind(this.row, "top", this.dasRow, "minLayout");
        this.applicationController.bind(this.row, "bottom", this.dasRow, "maxLayout");
        this.doSetParentRow(null, this.row.getParent());
        this.canvas = canvas;
    }

    public boolean isLayoutEqual(String spec) throws ParseException {
        String[] ss = spec.split(",");
        String s1 = DasDevicePosition.formatFormatStr((double[])DasDevicePosition.parseLayoutStr((String)ss[0]));
        if (!this.row.top.equals(s1)) {
            return false;
        }
        s1 = DasDevicePosition.formatFormatStr((double[])DasDevicePosition.parseLayoutStr((String)ss[1]));
        return this.row.bottom.equals(s1);
    }

    public void removeBindings() {
        this.applicationController.unbind(this.row);
        this.row.removePropertyChangeListener("parent", this.nameListener);
    }

    public void removeReferences() {
    }

    public DasRow getDasRow() {
        return this.dasRow;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

